<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('banks', function (Blueprint $table) {
            // Keep engine/collation consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            // Timestamps first in your dump; order doesn't matter functionally
            $table->timestamps(); // created_at, updated_at (nullable by default)

            $table->string('name', 191);                 // NOT NULL
            $table->string('bank_account_no', 191)->nullable();
            $table->string('bank_name', 191)->nullable();
            $table->string('branch_name', 191)->nullable();
            $table->string('branch_mobile', 191)->nullable();
            $table->string('branch_email', 191)->nullable();
            $table->text('branch_address')->nullable();

            // FK columns (constraints added in next migration)
            $table->unsignedBigInteger('company_id');          // NOT NULL
            $table->unsignedBigInteger('created_by');          // NOT NULL
            $table->unsignedBigInteger('updated_by')->nullable();

            // Indexes exactly as shown in your dump
            $table->index('company_id', 'banks_company_id_foreign');
            $table->index('created_by', 'banks_created_by_foreign');
            $table->index('updated_by', 'banks_updated_by_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('banks');
    }
};

