<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // Detect bag/product master table (project naming varies)
        $productTable = null;
        if (Schema::hasTable('finish_bags')) {
            $productTable = 'finish_bags';
        } elseif (Schema::hasTable('bags')) {
            $productTable = 'bags';
        } elseif (Schema::hasTable('raw_bags')) {
            $productTable = 'raw_bags';
        } elseif (Schema::hasTable('products')) { // fallback if you actually store bags in products
            $productTable = 'products';
        }

        Schema::table('bag_purchase_details', function (Blueprint $table) use ($productTable) {
            // Parent purchase (nullable → cascade so lines go away with header)
            if (Schema::hasTable('bag_purchases')) {
                $table->foreign('bag_purchase_id', 'bpd_purchase_fk')
                      ->references('id')->on('bag_purchases')
                      ->onUpdate('cascade')
                      ->onDelete('cascade');
            }

            // Product/Bag (nullable → restrict)
            if ($productTable) {
                $table->foreign('product_id', 'bpd_product_fk')
                      ->references('id')->on($productTable)
                      ->onUpdate('cascade')
                      ->onDelete('restrict');
            }
        });
    }

    public function down(): void
    {
        Schema::table('bag_purchase_details', function (Blueprint $table) {
            try { $table->dropForeign('bpd_purchase_fk'); } catch (\Throwable $e) {}
            try { $table->dropForeign('bpd_product_fk'); } catch (\Throwable $e) {}
        });
    }
};
