<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('bag_purchase_details', function (Blueprint $table) {
            // Consistency
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED

            // FK columns only (constraints added next migration)
            $table->unsignedBigInteger('bag_purchase_id')->nullable(); // -> bag_purchases.id
            $table->unsignedBigInteger('product_id')->nullable();      // bag master id (finish_bags / bags / raw_bags) or products

            $table->decimal('price',       10, 2)->nullable();
            $table->decimal('quantity',     8, 2)->nullable();
            $table->decimal('total_price',  8, 2)->nullable();

            $table->string('remarks', 191)->nullable();

            $table->timestamps();

            // Indexes (as in your dump)
            $table->index('bag_purchase_id', 'bpd_purchase_idx');
            $table->index('product_id',      'bpd_product_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('bag_purchase_details');
    }
};
