<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('bag_purchases', function (Blueprint $table) {
            // Consistent engine/collation
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED

            // FK columns (constraints added in next migration)
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('warehouse_id')->nullable();

            $table->string('invoice_no', 191)->nullable();

            $table->unsignedBigInteger('supplier_id')->nullable(); // Index in dump
            $table->unsignedBigInteger('employee_id')->nullable(); // Index in dump

            // Your dump shows varchar(191) for date
            $table->string('date', 191)->nullable();

            $table->string('payment_type', 191)->nullable();

            $table->decimal('subtotal',       16, 2)->nullable();
            $table->decimal('discount',       16, 2)->nullable();
            $table->decimal('vat',            16, 2)->nullable();
            $table->decimal('payable_amount', 16, 2)->nullable();
            $table->decimal('paid_amount',    16, 2)->nullable();
            $table->decimal('due_amount',     16, 2)->nullable();

            $table->string('reference', 191)->nullable();
            $table->text('attachment')->nullable();

            $table->unsignedBigInteger('created_by')->nullable(); // Index in dump
            $table->unsignedBigInteger('updated_by')->nullable(); // Index in dump

            $table->timestamps();

            // type: 1 => raw Bag, 2 => finish Bag
            $table->tinyInteger('type')->nullable()->comment('1 => raw Bag, 2 => finish Bag');

            // Indexes exactly as your dump lists
            $table->index('supplier_id', 'bag_purchases_supplier_id_foreign');
            $table->index('employee_id', 'bag_purchases_employee_id_foreign');
            $table->index('created_by',  'bag_purchases_created_by_foreign');
            $table->index('updated_by',  'bag_purchases_updated_by_foreign');

            // Optional helpful indexes (uncomment if you want them)
            // $table->index('company_id',  'bag_purchases_company_idx');
            // $table->index('warehouse_id','bag_purchases_wh_idx');
            // $table->index('date',        'bag_purchases_date_idx');
            // $table->index('invoice_no',  'bag_purchases_invoice_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('bag_purchases');
    }
};

