<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('areas', function (Blueprint $table) {
            if (Schema::hasTable('users')) {
                // created_by (nullable → SET NULL)
                $table->foreign('created_by', 'areas_created_by_foreign')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');

                // updated_by (nullable → SET NULL)
                $table->foreign('updated_by', 'areas_updated_by_foreign')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        Schema::table('areas', function (Blueprint $table) {
            // Guarded drops
            try { $table->dropForeign('areas_created_by_foreign'); } catch (\Throwable $e) {}
            try { $table->dropForeign('areas_updated_by_foreign'); } catch (\Throwable $e) {}
        });
    }
};
