<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('areas', function (Blueprint $table) {
            // Engine & collation
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();                                       // BIGINT UNSIGNED AI
            $table->string('name', 191);                        // NOT NULL (add unique if you prefer)
            $table->string('status', 191)->default('1');        // VARCHAR per your dump

            // FK columns (nullable)
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();                               // created_at / updated_at
            $table->softDeletes();                              // <-- adds deleted_at (fixes the error)

            // Indexes to match dump
            $table->index('created_by', 'areas_created_by_idx');
            $table->index('updated_by', 'areas_updated_by_idx');

            // If you want hard FKs (optional; comment out if users not guaranteed)
            // $table->foreign('created_by')->references('id')->on('users')->nullOnDelete()->cascadeOnUpdate();
            // $table->foreign('updated_by')->references('id')->on('users')->nullOnDelete()->cascadeOnUpdate();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('areas');
    }
};


