<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('activity_logs', function (Blueprint $table) {
            // Keep things consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            $table->string('log_name', 191)->nullable();
            $table->text('description'); // NOT NULL

            // Polymorphic subject
            $table->string('subject_type', 191)->nullable();
            $table->unsignedBigInteger('subject_id')->nullable();

            // Polymorphic causer
            $table->string('causer_type', 191)->nullable();
            $table->unsignedBigInteger('causer_id')->nullable();

            // JSON/props, binary collation as per dump
            $table->longText('properties')->nullable()->collation('utf8mb4_bin');

            $table->timestamps();

            // Indexes (names match your dump)
            $table->index(['subject_type', 'subject_id'], 'subject');
            $table->index(['causer_type', 'causer_id'],   'causer');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('activity_logs');
    }
};

