<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_system_settings', function (Blueprint $table) {
            // Keep engine/collation consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            $table->string('income_statement_sales1', 191)->nullable();
            $table->string('income_statement_sales2', 191)->nullable();
            $table->string('income_statement_cost_of_goods_sold', 191)->nullable();
            $table->string('income_statement_financial_expenses', 191)->nullable();

            $table->timestamps(); // created_at, updated_at (nullable by default)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_system_settings');
    }
};

