<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // Detect accounts table name if your project differs
        $accountsTable = null;
        if (Schema::hasTable('accounts')) {
            $accountsTable = 'accounts';
        } elseif (Schema::hasTable('acc_accounts')) {
            $accountsTable = 'acc_accounts';
        }

        Schema::table('acc_suppliers', function (Blueprint $table) use ($accountsTable) {
            // account_id (nullable → SET NULL)
            if ($accountsTable) {
                $table->foreign('account_id', 'acc_suppliers_account_fk')
                      ->references('id')->on($accountsTable)
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }

            // company_id (nullable → SET NULL)
            if (Schema::hasTable('companies')) {
                $table->foreign('company_id', 'acc_suppliers_company_fk')
                      ->references('id')->on('companies')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }

            // created_by (required → RESTRICT)
            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'acc_suppliers_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');

                // updated_by (nullable → SET NULL)
                $table->foreign('updated_by', 'acc_suppliers_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        Schema::table('acc_suppliers', function (Blueprint $table) {
            // Guarded drops in case some weren’t created
            try { $table->dropForeign('acc_suppliers_account_fk'); } catch (\Throwable $e) {}
            try { $table->dropForeign('acc_suppliers_company_fk'); } catch (\Throwable $e) {}
            try { $table->dropForeign('acc_suppliers_created_by_fk'); } catch (\Throwable $e) {}
            try { $table->dropForeign('acc_suppliers_updated_by_fk'); } catch (\Throwable $e) {}
        });
    }
};

