<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_suppliers', function (Blueprint $table) {
            // Consistent engine/collation
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED

            $table->string('name', 191);
            $table->string('mobile', 191)->nullable();
            $table->string('email', 191)->nullable();
            $table->text('address')->nullable();

            $table->float('opening_balance')->default(0); // per dump (float)
            $table->float('current_balance')->default(0); // per dump (float)

            // FK columns only (constraints added next migration)
            $table->unsignedBigInteger('account_id')->nullable(); // -> accounts.id
            $table->unsignedBigInteger('company_id')->nullable(); // -> companies.id
            $table->unsignedBigInteger('created_by');             // -> users.id
            $table->unsignedBigInteger('updated_by')->nullable(); // -> users.id

            $table->decimal('previous_due', 8, 2)->default(0.00);

            $table->timestamps();

            // Indexes (as shown in your dump)
            $table->index('account_id', 'acc_suppliers_account_idx');
            $table->index('company_id', 'acc_suppliers_company_idx');
            $table->index('created_by', 'acc_suppliers_created_by_idx');
            $table->index('updated_by', 'acc_suppliers_updated_by_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_suppliers');
    }
};
