<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_stock_summaries', function (Blueprint $table) {
            // Consistent engine/collation
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED

            // FK columns (constraints added next migration)
            $table->unsignedBigInteger('company_id');              // required
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->unsignedBigInteger('warehouse_id')->nullable();
            $table->unsignedBigInteger('product_id');              // required

            // Quantities (nullable with defaults per dump)
            $table->double('opening_qty')->nullable()->default(0);
            $table->double('purchase_qty')->nullable()->default(0);
            $table->double('sale_qty')->nullable()->default(0);
            $table->double('issue_qty')->nullable()->default(0);
            $table->double('purchase_return_qty')->nullable()->default(0);
            $table->double('sale_return_qty')->nullable()->default(0);
            $table->double('transfer_in_qty')->nullable()->default(0);
            $table->double('transfer_out_qty')->nullable()->default(0);

            // available_qty = inflows - outflows (VIRTUAL)
            $table->double('available_qty')->nullable()->virtualAs(
                '(COALESCE(opening_qty,0) + COALESCE(purchase_qty,0) + COALESCE(transfer_in_qty,0) + COALESCE(sale_return_qty,0)'
                .' - (COALESCE(sale_qty,0) + COALESCE(issue_qty,0) + COALESCE(purchase_return_qty,0) + COALESCE(transfer_out_qty,0)))'
            );

            // Amount
            $table->decimal('total_amount', 15, 2); // NOT NULL per dump

            // Audit
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();

            // Indexes (match your dump)
            $table->index('company_id', 'ass_company_idx');
            $table->index('product_id', 'ass_product_idx');
            $table->index('created_by', 'ass_created_by_idx');
            $table->index('updated_by', 'ass_updated_by_idx');

            // Optional (helpful) indexes—uncomment if you want them
            // $table->index('branch_id', 'ass_branch_idx');
            // $table->index('warehouse_id', 'ass_wh_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_stock_summaries');
    }
};
