<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_sale_return_details', function (Blueprint $table) {
            // Keep consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED

            // FK columns only (constraints added in next migration)
            $table->unsignedBigInteger('sale_return_id')->nullable(); // -> acc_sale_returns.id
            $table->unsignedBigInteger('sale_detail_id')->nullable(); // -> acc_sale_details.id
            $table->unsignedBigInteger('product_id');                 // -> products/finish_products/raw_materials.id

            $table->string('product_type', 191)->default('Good')->comment('Good, Damage');
            $table->decimal('quantity', 20, 2)->default(0.00);
            $table->decimal('price',    20, 2)->default(0.00);
            $table->decimal('subtotal', 20, 2)->default(0.00);

            $table->timestamps();

            // Short index names
            $table->index('sale_return_id', 'asrd_parent_idx');
            $table->index('sale_detail_id', 'asrd_detail_idx');
            $table->index('product_id',     'asrd_product_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_sale_return_details');
    }
};
