<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // Detect customer table (you’ve been using acc_customers)
        $customerTable = Schema::hasTable('acc_customers') ? 'acc_customers'
                        : (Schema::hasTable('customers') ? 'customers' : null);

        // Detect branch table
        $branchTable = Schema::hasTable('branches') ? 'branches'
                     : (Schema::hasTable('acc_branches') ? 'acc_branches' : null);

        Schema::table('acc_sale_returns', function (Blueprint $table) use ($customerTable, $branchTable) {
            // sale (nullable → SET NULL)
            if (Schema::hasTable('acc_sales')) {
                $table->foreign('sale_id', 'asr_sale_fk')
                      ->references('id')->on('acc_sales')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }

            // customer (required)
            if ($customerTable) {
                $table->foreign('customer_id', 'asr_customer_fk')
                      ->references('id')->on($customerTable)
                      ->onUpdate('cascade')
                      ->onDelete('restrict');
            }

            // company (nullable)
            if (Schema::hasTable('companies')) {
                $table->foreign('company_id', 'asr_company_fk')
                      ->references('id')->on('companies')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }

            // branch (nullable)
            if ($branchTable) {
                $table->foreign('branch_id', 'asr_branch_fk')
                      ->references('id')->on($branchTable)
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }

            // users (created_by required, updated_by nullable)
            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'asr_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');

                $table->foreign('updated_by', 'asr_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        Schema::table('acc_sale_returns', function (Blueprint $table) {
            // Drop by names; guard in case some weren’t created
            try { $table->dropForeign('asr_sale_fk'); } catch (\Throwable $e) {}
            try { $table->dropForeign('asr_customer_fk'); } catch (\Throwable $e) {}
            try { $table->dropForeign('asr_company_fk'); } catch (\Throwable $e) {}
            try { $table->dropForeign('asr_branch_fk'); } catch (\Throwable $e) {}
            try { $table->dropForeign('asr_created_by_fk'); } catch (\Throwable $e) {}
            try { $table->dropForeign('asr_updated_by_fk'); } catch (\Throwable $e) {}
        });
    }
};

