<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_sale_returns', function (Blueprint $table) {
            // Keep consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED

            // Columns (per your dump)
            $table->string('date', 191);                 // NOT NULL
            $table->string('invoice_no', 191)->nullable();
            $table->unsignedBigInteger('sale_id')->nullable();     // -> acc_sales.id
            $table->unsignedBigInteger('customer_id');             // -> acc_customers.id (required)
            $table->unsignedBigInteger('company_id')->nullable();  // -> companies.id
            $table->unsignedBigInteger('branch_id')->nullable();   // -> branches.id
            $table->unsignedBigInteger('created_by');              // -> users.id
            $table->unsignedBigInteger('updated_by')->nullable();  // -> users.id

            // Totals (decimal(20,2) NOT NULL default 0.00)
            $table->decimal('total_return_amount',   20, 2)->default(0);
            $table->decimal('total_exchange_amount', 20, 2)->default(0);
            $table->decimal('total_amount',          20, 2)->default(0);
            $table->decimal('total_discount',        20, 2)->default(0);
            $table->decimal('total_payable',         20, 2)->default(0);
            $table->decimal('total_paid_amount',     20, 2)->default(0);
            $table->decimal('total_due_amount',      20, 2)->default(0);

            $table->timestamps();

            // Short, explicit indexes
            $table->index('customer_id', 'asr_customer_idx'); // shown as Index in your dump
            $table->index('company_id',  'asr_company_idx');  // shown as Index in your dump
            $table->index('sale_id',     'asr_sale_idx');
            $table->index('branch_id',   'asr_branch_idx');
            $table->index('created_by',  'asr_created_by_idx');
            $table->index('updated_by',  'asr_updated_by_idx');
            $table->index('date',        'asr_date_idx');
            $table->index('invoice_no',  'asr_invoice_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_sale_returns');
    }
};

