<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_sale_exchange_details', function (Blueprint $table) {
            // Keep consistent with other tables
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED

            // FK columns only (constraints added in next migration)
            $table->unsignedBigInteger('sale_return_id')->nullable(); // -> acc_sale_returns.id (or acc_sale_exchanges.id)
            $table->unsignedBigInteger('product_id');                 // -> products/finish_products/raw_materials.id

            $table->decimal('quantity', 20, 2)->default(0);
            $table->decimal('price',    20, 2)->default(0);
            $table->decimal('subtotal', 20, 2)->default(0);

            $table->timestamps();

            // Short index names
            $table->index('sale_return_id', 'ased_parent_idx');
            $table->index('product_id',     'ased_product_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_sale_exchange_details');
    }
};
