<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_sale_details', function (Blueprint $table) {
            // Keep consistent with other tables
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            $table->string('transaction_no', 191)->nullable();

            // FK columns (constraints added in next migration)
            $table->unsignedBigInteger('product_id'); // -> products/finish_products/raw_materials.id
            $table->unsignedBigInteger('sale_id');    // -> acc_sales.id

            $table->float('quantity')->default(0);          // matches your dump
            $table->decimal('price', 16, 2)->default(0);

            // amount = quantity * price (VIRTUAL GENERATED)
            $table->decimal('amount', 16, 2)->nullable()->virtualAs('quantity * price');

            $table->text('description')->nullable();

            $table->timestamps();

            // Short index names
            $table->index('product_id', 'asd_product_idx');
            $table->index('sale_id',    'asd_sale_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_sale_details');
    }
};

