<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_sales', function (Blueprint $table) {
            // Keep consistent with others
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED

            // FK columns only (constraints added in next migration)
            $table->unsignedBigInteger('customer_id');          // -> acc_customers.id (required)
            $table->string('date', 191);                        // varchar(191) NOT NULL
            $table->string('invoice_no', 191);                  // NOT NULL, unique

            // Totals
            $table->decimal('qty_total',       16, 2)->default(0);
            $table->decimal('qty_amount',      16, 2)->default(0);
            $table->decimal('discount_amount', 16, 2)->default(0);
            $table->decimal('total_amount',    16, 2)->default(0);
            $table->decimal('previous_due',    16, 2)->default(0);
            $table->decimal('payable_amount',  16, 2)->default(0);
            $table->decimal('paid_amount',     16, 2)->default(0);
            $table->decimal('due_amount',      16, 2)->default(0);

            $table->unsignedBigInteger('company_id')->nullable(); // -> companies.id
            $table->unsignedBigInteger('created_by');             // -> users.id
            $table->unsignedBigInteger('updated_by')->nullable(); // -> users.id

            $table->timestamps();

            // Indexes (use short names to avoid 64-char limits)
            $table->unique('invoice_no', 'acc_sales_invoice_no_unique');
            $table->index('customer_id', 'acc_sales_customer_idx');
            $table->index('company_id',  'acc_sales_company_idx');
            $table->index('created_by',  'acc_sales_created_by_idx');
            $table->index('updated_by',  'acc_sales_updated_by_idx');
            $table->index('date',        'acc_sales_date_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_sales');
    }
};

