<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            // Keep engine/collation consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED

            // FK columns only (constraints added in next migration)
            $table->unsignedBigInteger('company_id');        // -> companies.id (required)
            $table->unsignedBigInteger('branch_id')->nullable(); // -> branches/acc_branches.id (nullable)

            // Core fields
            $table->string('name', 191);
            $table->string('email', 191)->nullable();
            $table->timestamp('email_verified_at')->nullable();

            $table->string('password', 191);
            $table->rememberToken(); // varchar(100) nullable

            // Extra fields per your schema
            $table->tinyInteger('status')->nullable()->default(1);
            $table->string('api_token', 191)->nullable()->unique();
            $table->string('password_reset_token', 191)->nullable();
            $table->string('employee_full_id', 191)->nullable();
            $table->string('device_token', 191)->nullable();

            $table->timestamps();

            // Helpful indexes (short names to avoid 64-char limit)
            $table->index('company_id', 'users_company_idx');
            $table->index('branch_id',  'users_branch_idx');
            $table->index('status',     'users_status_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};


