<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('companies', function (Blueprint $table) {
            // Keep consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            // PK
            $table->id(); // BIGINT UNSIGNED

            // FK columns only (constraints added in next migration)
            $table->unsignedBigInteger('group_id');            // -> groups.id
            $table->unsignedBigInteger('business_type_id')->nullable(); // -> business_types.id

            // Fields
            $table->string('name', 191);
            $table->string('code', 50)->nullable()->unique(); // companies_code_unique
            $table->string('short_name', 191)->nullable();

            $table->text('head_office')->nullable();
            $table->text('factory')->nullable();

            $table->string('contact_name', 191)->nullable();
            $table->string('position', 191)->nullable();
            $table->string('phone_number', 191)->nullable();
            $table->string('fax', 20)->nullable();
            $table->string('email', 100)->nullable();

            $table->string('day_off', 191)->nullable();
            $table->string('starting_month', 191)->nullable();
            $table->string('country', 191)->nullable();

            $table->text('top_text')->nullable();
            $table->string('logo', 191)->nullable();

            $table->string('business_type', 191)->nullable(); // as in your dump
            $table->tinyInteger('status')->nullable()->default(1);

            $table->date('starting_date')->nullable();
            $table->date('closing_date')->nullable();

            $table->timestamps();

            // Helpful indexes (short names to avoid 64-char error)
            $table->index('group_id', 'companies_group_idx');
            $table->index('business_type_id', 'companies_bus_type_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('companies');
    }
};

