<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_purchase_return_details', function (Blueprint $table) {
            // keep consistent with others
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            // FK columns only (constraints added in next migration)
            $table->unsignedBigInteger('purchase_return_id')->nullable(); // -> acc_purchase_returns.id
            $table->unsignedBigInteger('purchase_detail_id')->nullable(); // -> acc_purchase_details.id
            $table->unsignedBigInteger('product_id');                     // -> products/finish_products/raw_materials.id

            // Good / Damage
            $table->string('product_type', 191)->default('Good')->comment('Good, Damage');

            $table->decimal('quantity', 20, 2)->default(0);
            $table->decimal('price',    20, 2)->default(0);
            $table->decimal('subtotal', 20, 2)->default(0);

            $table->timestamps();

            // short index names
            $table->index('purchase_return_id', 'aprd_parent_idx');
            $table->index('purchase_detail_id', 'aprd_detail_idx');
            $table->index('product_id',         'aprd_product_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_purchase_return_details');
    }
};


