<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_purchase_returns', function (Blueprint $table) {
            // keep consistent with others
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            // your schema uses VARCHAR(191) for date
            $table->string('date', 191);
            $table->string('invoice_no', 191)->nullable();

            // FK columns only (constraints added in next migration)
            $table->unsignedBigInteger('purchase_id')->nullable(); // -> acc_purchases.id
            $table->unsignedBigInteger('supplier_id');             // -> suppliers/acc_suppliers.id
            $table->unsignedBigInteger('company_id')->nullable();  // -> companies.id
            $table->unsignedBigInteger('branch_id')->nullable();   // -> branches.id
            $table->unsignedBigInteger('created_by');              // -> users.id
            $table->unsignedBigInteger('updated_by')->nullable();  // -> users.id

            // totals
            $table->decimal('total_return_amount',   20, 2)->default(0);
            $table->decimal('total_exchange_amount', 20, 2)->default(0);
            $table->decimal('total_amount',          20, 2)->default(0);
            $table->decimal('total_discount',        20, 2)->default(0);
            $table->decimal('total_payable',         20, 2)->default(0);
            $table->decimal('total_paid_amount',     20, 2)->default(0);
            $table->decimal('total_due_amount',      20, 2)->default(0);

            $table->timestamps();

            // short index names (avoid 64-char limit)
            $table->index(['supplier_id', 'company_id'], 'apr_supplier_company_idx');
            $table->index('date', 'apr_date_idx');
            $table->index('invoice_no', 'apr_invoice_idx');
            $table->index('purchase_id', 'apr_purchase_idx');
            $table->index('branch_id', 'apr_branch_idx');
            $table->index('created_by', 'apr_created_by_idx');
            $table->index('updated_by', 'apr_updated_by_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_purchase_returns');
    }
};


