<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_purchase_exchange_details', function (Blueprint $table) {
            // keep consistent with other tables
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            // FK columns only (constraints added next migration)
            $table->unsignedBigInteger('purchase_return_id')->nullable(); // -> acc_purchase_returns.id OR acc_purchase_exchanges.id
            $table->unsignedBigInteger('product_id');                     // -> products/finish_products/raw_materials.id

            $table->decimal('quantity', 20, 2)->default(0);
            $table->decimal('price',    20, 2)->default(0);
            $table->decimal('subtotal', 20, 2)->default(0);

            $table->timestamps();

            // short, explicit indexes
            $table->index('purchase_return_id', 'apexd_parent_idx');
            $table->index('product_id',         'apexd_product_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_purchase_exchange_details');
    }
};


