<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_purchase_details', function (Blueprint $table) {
            // keep consistent with others
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            $table->string('transaction_no', 191)->nullable();

            // FK columns only (constraints added in next migration)
            $table->unsignedBigInteger('product_id');   // -> products/finish_products/raw_materials.id
            $table->unsignedBigInteger('purchase_id');  // -> acc_purchases.id

            // quantities & pricing
            $table->float('quantity')->default(0);           // matches your schema's float
            $table->decimal('price', 16, 2)->default(0);

            // amount = quantity * price (virtual)
            $table->decimal('amount', 16, 2)->nullable()->virtualAs('quantity * price');

            $table->text('description')->nullable();

            $table->timestamps();

            // short index names
            $table->index('product_id',  'acc_purd_product_idx');
            $table->index('purchase_id', 'acc_purd_purchase_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_purchase_details');
    }
};

