<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_purchases', function (Blueprint $table) {
            // Keep consistent with other tables
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            // FK columns only (FKs added in next migration)
            $table->unsignedBigInteger('supplier_id');           // -> suppliers/acc_suppliers.id (required)
            $table->string('date', 191);                         // keeping varchar per your schema
            $table->string('invoice_no', 191);                   // required

            // Totals
            $table->decimal('qty_total',       16, 2)->default(0);
            $table->decimal('qty_amount',      16, 2)->default(0);
            $table->decimal('discount_amount', 16, 2)->default(0);
            $table->decimal('total_amount',    16, 2)->default(0);
            $table->decimal('previous_due',    16, 2)->default(0);
            $table->decimal('payable_amount',  16, 2)->default(0);
            $table->decimal('paid_amount',     16, 2)->default(0);
            $table->decimal('due_amount',      16, 2)->default(0);

            $table->unsignedBigInteger('company_id')->nullable(); // -> companies.id
            $table->unsignedBigInteger('created_by');             // -> users.id
            $table->unsignedBigInteger('updated_by')->nullable(); // -> users.id

            // Polymorphic source
            $table->string('sourceable_type', 191)->nullable();
            $table->unsignedBigInteger('sourceable_id')->nullable();
            $table->string('source', 191)->nullable()->default('Account')
                  ->comment('Account, Production and so on.');

            $table->timestamps();

            // Indexes (short names)
            $table->index(['supplier_id', 'company_id'], 'acc_pur_supplier_company_idx');
            $table->index('date', 'acc_pur_date_idx');
            $table->index('invoice_no', 'acc_pur_invoice_idx');
            $table->index(['sourceable_type', 'sourceable_id'], 'acc_pur_sourceable_idx');

            // Optional: unique per company + invoice
            // $table->unique(['company_id', 'invoice_no'], 'acc_pur_company_invoice_uniq');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_purchases');
    }
};


