<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_payments', function (Blueprint $table) {
            // keep consistent with other tables
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            // FK columns only (constraints added in next migration)
            $table->unsignedBigInteger('supplier_id');          // -> suppliers/acc_suppliers.id
            $table->string('date', 191);

            $table->string('invoice_no', 191)->nullable();
            $table->string('transaction_no', 191)->nullable();
            $table->string('remarks', 191)->nullable();

            $table->decimal('amount', 16, 2)->default(0);

            $table->unsignedBigInteger('company_id')->nullable(); // -> companies.id
            $table->unsignedBigInteger('created_by');             // -> users.id
            $table->unsignedBigInteger('updated_by')->nullable(); // -> users.id

            $table->timestamps();

            // Helpful indexes (short names)
            $table->index(['supplier_id', 'company_id'], 'acc_pay_supplier_company_idx');
            $table->index('date', 'acc_pay_date_idx');
            $table->index('invoice_no', 'acc_pay_invoice_idx');
            $table->index('created_by', 'acc_pay_created_by_idx');
            $table->index('updated_by', 'acc_pay_updated_by_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_payments');
    }
};

