<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_damage_details', function (Blueprint $table) {
            // Keep engine/collation consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            // FK columns only (constraints added in next migration)
            $table->unsignedBigInteger('damage_id')->nullable(); // -> acc_damages.id
            $table->unsignedBigInteger('product_id');            // -> products/finish_products/raw_materials.id

            $table->decimal('quantity', 20, 2)->default(0);
            $table->decimal('price',    20, 2)->default(0);
            $table->decimal('subtotal', 20, 2)->default(0);

            $table->timestamps();

            // Helpful indexes (short names)
            $table->index('damage_id',  'acc_dmgd_damage_idx');
            $table->index('product_id', 'acc_dmgd_product_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_damage_details');
    }
};


