<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_damages', function (Blueprint $table) {
            // Keep consistent with other tables
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            // Your schema uses varchar(191) for date
            $table->string('date', 191);
            $table->string('invoice_no', 191)->nullable();

            // FK columns (constraints added in next migration)
            $table->unsignedBigInteger('sale_return_id')->nullable(); // -> acc_purchase_returns.id (or sale_returns.id)
            $table->unsignedBigInteger('company_id')->nullable();     // -> companies.id
            $table->unsignedBigInteger('branch_id')->nullable();      // -> branches.id
            $table->unsignedBigInteger('created_by');                 // -> users.id
            $table->unsignedBigInteger('updated_by')->nullable();     // -> users.id

            // Amount
            $table->decimal('total_amount', 20, 2)->default(0);

            $table->timestamps();

            // Helpful indexes (short names to avoid 64-char limit)
            $table->index('company_id', 'acc_dmg_company_idx');
            $table->index('branch_id', 'acc_dmg_branch_idx');
            $table->index('sale_return_id', 'acc_dmg_sale_return_idx');
            $table->index('created_by', 'acc_dmg_created_by_idx');
            $table->index('updated_by', 'acc_dmg_updated_by_idx');
            $table->index('date', 'acc_dmg_date_idx');
            $table->index('invoice_no', 'acc_dmg_invoice_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_damages');
    }
};

