<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_customers', function (Blueprint $table) {
            // Keep engine/collation consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED

            $table->string('name', 191);
            $table->string('mobile', 191)->nullable();
            $table->string('email', 191)->nullable();
            $table->text('address')->nullable();

            $table->decimal('opening_balance', 16, 2)->default(0);
            $table->decimal('current_balance', 16, 2)->default(0);

            // FK columns only (constraints in next migration)
            $table->unsignedBigInteger('account_id')->nullable(); // -> accounts.id
            $table->unsignedBigInteger('company_id')->nullable(); // -> companies.id

            // Audit
            $table->unsignedBigInteger('created_by');             // -> users.id
            $table->unsignedBigInteger('updated_by')->nullable(); // -> users.id

            $table->decimal('previous_due', 8, 2)->default(0);

            $table->timestamps();

            // Helpful indexes (short names to avoid 64-char limit)
            $table->index(['company_id', 'name'], 'acc_cust_company_name_idx');
            $table->index('account_id', 'acc_cust_account_idx');
            $table->index('created_by', 'acc_cust_created_by_idx');
            $table->index('updated_by', 'acc_cust_updated_by_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_customers');
    }
};

