<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_collections', function (Blueprint $table) {
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            // FK columns (constraints added in the next migration)
            $table->unsignedBigInteger('customer_id');           // -> acc_customers.id
            $table->string('date', 191);                         // keeping VARCHAR per your schema
            $table->string('invoice_no', 191)->nullable();
            $table->string('transaction_no', 191)->nullable();
            $table->string('remarks', 191)->nullable();
            $table->decimal('amount', 16, 2)->default(0);

            $table->unsignedBigInteger('company_id')->nullable(); // -> companies.id
            $table->unsignedBigInteger('created_by');             // -> users.id
            $table->unsignedBigInteger('updated_by')->nullable(); // -> users.id

            $table->timestamps();

            // Helpful indexes (short names to avoid 64-char limit)
            $table->index(['customer_id', 'company_id'], 'acc_coll_customer_company_idx');
            $table->index('date', 'acc_coll_date_idx');
            $table->index('invoice_no', 'acc_coll_inv_idx');
            $table->index('created_by', 'acc_coll_created_by_idx');
            $table->index('updated_by', 'acc_coll_updated_by_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_collections');
    }
};


