<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('acc_categories', function (Blueprint $table) {
            // keep consistent with referenced tables
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            $table->string('name', 191);

            // FK columns only (constraints added in next migration)
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();

            // helpful indexes
            $table->index(['company_id', 'name'], 'acc_cat_company_name_idx');
            $table->index('created_by', 'acc_cat_created_by_idx');
            $table->index('updated_by', 'acc_cat_updated_by_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('acc_categories');
    }
};

