<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('account_year_closing_tracks', function (Blueprint $table) {
            // Keep consistent with your other tables
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED

            // FK columns (add constraints in next migration)
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            // Period
            $table->date('starting_date')->nullable();
            $table->date('closing_date')->nullable();

            // Financials (mirror your schema)
            $table->double('owners_equity', 16, 2)->default(0);
            $table->double('profit', 16, 2)->default(0);
            $table->double('operating_income', 16, 2)->default(0);
            $table->double('cost_of_good_sold', 16, 2)->default(0);
            $table->double('non_operating_income', 16, 2)->default(0);
            $table->double('operating_expenses', 16, 2)->default(0);
            $table->double('non_operating_expenses', 16, 2)->default(0);

            $table->timestamps();

            // ✅ Short, explicit index names (avoid “identifier too long”)
            $table->index(['company_id', 'starting_date', 'closing_date'], 'ayct_company_period_idx');
            $table->index('created_by', 'ayct_created_by_idx');
            $table->index('updated_by', 'ayct_updated_by_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('account_year_closing_tracks');
    }
};


