<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('account_subsidiaries', function (Blueprint $table) {
            // Match engine/collation with referenced tables
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            $table->string('name', 191);

            // Columns only (FKs added in a separate migration)
            $table->unsignedBigInteger('account_group_id')->nullable();
            $table->unsignedBigInteger('account_control_id')->nullable();
            $table->unsignedBigInteger('company_id')->nullable();

            $table->tinyInteger('status')->default(1);
            $table->tinyInteger('is_deletable')->default(1);

            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();

            // Helpful indexes
            $table->index(['company_id', 'status']);
            $table->index('account_group_id');
            $table->index('account_control_id');
            $table->index('created_by');
            $table->index('updated_by');

            // If you need unique per company:
            // $table->unique(['company_id', 'name']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('account_subsidiaries');
    }
};

