<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('account_setups', function (Blueprint $table) {
            // Match engine/collation with companies
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();

            $table->string('name', 191);

            // Columns only (FK added in a separate migration)
            $table->unsignedBigInteger('company_id')->nullable();

            $table->tinyInteger('status')->default(1);
            $table->tinyInteger('is_deletable')->default(1);

            $table->timestamps();

            // Helpful indexes
            $table->index('company_id');
            $table->index('status');
            // $table->unique(['company_id', 'name']); // if you want uniqueness per company
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('account_setups');
    }
};

