<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('account_opening_balances', function (Blueprint $table) {
            // Ensure engine/collation match other tables
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            // Keep as string per your schema
            $table->string('date', 191)->nullable();

            // Columns only (NO FKs yet)
            $table->unsignedBigInteger('account_id');           // must match accounts.id (BIGINT UNSIGNED)
            $table->unsignedBigInteger('company_id')->nullable(); // nullable because ON DELETE SET NULL
            $table->decimal('amount', 16, 2)->default(0);

            $table->unsignedBigInteger('created_by');           // users.id
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();

            // Helpful indexes
            $table->index('account_id');
            $table->index('company_id');
            $table->index('created_by');
            $table->index('updated_by');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('account_opening_balances');
    }
};








