<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('account_groups', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('name', 191);

            // Debit/Credit enum (exactly as schema)
            $table->enum('balance_type', ['Debit', 'Credit']);

            $table->unsignedBigInteger('company_id')->nullable()->default(1)->index();

            $table->tinyInteger('status')->default(1);
            $table->tinyInteger('is_deletable')->default(1);

            $table->timestamps(); // created_at, updated_at (nullable)

            // ---- Optional foreign keys (uncomment & adjust if those tables exist) ----
            // $table->foreign('company_id')->references('id')->on('companies')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('account_groups');
    }
};
