<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('account_controls', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('name', 191);

            $table->unsignedBigInteger('account_group_id')->nullable()->index();
            $table->unsignedBigInteger('company_id')->nullable()->default(1)->index();

            $table->tinyInteger('status')->default(1);
            $table->tinyInteger('is_deletable')->default(1);

            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();

            // ---- Optional FKs (নিজের টেবিল নাম মিলিয়ে আনকমেন্ট করুন) ----
            // $table->foreign('account_group_id')->references('id')->on('account_groups')->nullOnDelete();
            // $table->foreign('company_id')->references('id')->on('companies')->nullOnDelete();
            // $table->foreign('created_by')->references('id')->on('users')->nullOnDelete();
            // $table->foreign('updated_by')->references('id')->on('users')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('account_controls');
    }
};
