<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('accounts', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('name', 191);

            $table->unsignedBigInteger('account_group_id')->nullable()->index();
            $table->unsignedBigInteger('account_control_id')->nullable()->index();
            $table->unsignedBigInteger('account_subsidiary_id')->nullable()->index();

            $table->unsignedBigInteger('company_id')->nullable()->default(1)->index();

            $table->enum('balance_type', ['Debit', 'Credit'])->nullable();

            $table->decimal('opening_balance', 15, 2)->default(0.00);

            $table->text('remarks')->nullable();

            $table->tinyInteger('status')->default(1);
            $table->tinyInteger('is_deletable')->default(1);

            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->string('account_no', 191)->nullable();

            $table->timestamps();

            // --- (Optional) Foreign keys: uncomment & adjust target tables if available ---
            // $table->foreign('account_group_id')->references('id')->on('account_groups')->nullOnDelete();
            // $table->foreign('account_control_id')->references('id')->on('account_controls')->nullOnDelete();
            // $table->foreign('account_subsidiary_id')->references('id')->on('account_subsidiaries')->nullOnDelete();
            // $table->foreign('company_id')->references('id')->on('companies')->nullOnDelete();
            // $table->foreign('created_by')->references('id')->on('users')->cascadeOnDelete();
            // $table->foreign('updated_by')->references('id')->on('users')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('accounts');
    }
};

