<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;

class UserFactory extends Factory
{
    protected $model = User::class;

    public function definition(): array
    {
        return [
            'company_id'           => 1,
            'branch_id'            => null,
            'name'                 => $this->faker->name(),
            'email'                => $this->faker->unique()->safeEmail(),
            'email_verified_at'    => now(),
            'password'             => Hash::make('12345678'),
            'remember_token'       => Str::random(10),
            'status'               => 1,
            'api_token'            => Str::random(60),
            'password_reset_token' => null,
            'employee_full_id'     => 'EMP-'.strtoupper(Str::random(6)),
            'device_token'         => null,
        ];
    }
}
