<?php
return [
  // --- Dashboard (single) ---
  ['label' => 'Home', 'icon' => 'fas fa-gauge', 'route' => 'home'],
  ['label'=>'User Access','icon'=>'fas fa-key','children'=>[
    ['label'=>'Users','route'=>'users.index'],
    ['label' => 'Roles', 'route' => 'roles.index'],
    ['label'=>'Permissions','route'=>'permissions.index'],
  ]],
  ['label'=>'Party','icon'=>'fas fa-handshake','children'=>[
    ['label'=>'Suppliers','children'=>[
      ['label'=>'Create','route'=>'suppliers.create'],
      ['label'=>'List','route'=>'suppliers.index'],
    ]],
    ['label'=>'Customers','children'=>[
      ['label'=>'Create','route'=>'customers.create'],
      ['label'=>'List','route'=>'customers.index'],
    ]],
    ['label'=>'Party Types','children'=>[
      ['label'=>'Create','route'=>'party_types.create'],
      ['label'=>'List','route'=>'party_types.index'],
    ]],
  ]],
  ['label'=>'Employee','icon'=>'fas fa-user-tie','children'=>[
    ['label'=>'Create','route'=>'employee.create'],
    ['label'=>'List','route'=>'employee.index'],
  ]],
  ['label'=>'Products','icon'=>'fas fa-gift','children'=>[
    ['label'=>'Unit List','route'=>'units.index'],
    ['label'=>'Category List','route'=>'categories.index'],
    ['label'=>'Bag Type List','route'=>'bag_types.index'],
    ['label'=>'Warehouse Type List','route'=>'warehouse_types.index'],
    ['label'=>'Warehouse List','route'=>'warehouses.index'],
    ['label'=>'Dayar List','route'=>'dayars.index'],
    ['label'=>'Mill List','route'=>'mills.index'],
    ['label'=>'Area List','route'=>'areas.index'],
    ['label'=>'Raw Material List','route'=>'raw_materials.index'],
    ['label'=>'Finish Product List','route'=>'finish_products.index'],
    ['label'=>'Finish Bag List','route'=>'finish_bags.index'],
  ]],
  ['label'=>'Purchase','icon'=>'fas fa-credit-card','children'=>[
    ['label'=>'Raw Material','children'=>[
      ['label'=>'New Purchase','route'=>'purchase.raw_material.create'],
      ['label'=>'Purchase List','route'=>'purchase.raw_material.index'],
    ]],
    ['label'=>'Finish Product','children'=>[
      ['label'=>'New Purchase','route'=>'purchase.finish_product.create'],
      ['label'=>'Purchase List','route'=>'purchase.finish_product.index'],
    ]],
    ['label'=>'Finish Bag','children'=>[
      ['label'=>'New Purchase','route'=>'purchase.finish_bag.create'],
      ['label'=>'Purchase List','route'=>'purchase.finish_bag.index'],
    ]],
    ['label'=>'Raw Bag','children'=>[
      ['label'=>'New Purchase','route'=>'purchase.raw_bag.create'],
      ['label'=>'Purchase List','route'=>'purchase.raw_bag.index'],
    ]],
  ]],
  ['label'=>'Bag Exchange','icon'=>'fas fa-exchange-alt','children'=>[
    ['label'=>'Create','route'=>'bag_exchange.create'],
    ['label'=>'List','route'=>'bag_exchange.index'],
  ]],
  ['label'=>'Stock Transfer','icon'=>'fas fa-external-link-alt','children'=>[
    ['label'=>'Create','route'=>'transfer.create'],
    ['label'=>'List','route'=>'transfer.index'],
  ]],
  ['label'=>'Adjustment','icon'=>'fas fa-balance-scale','children'=>[
    ['label'=>'Raw Product','children'=>[
      ['label'=>'Create','route'=>'adjustment.raw_product.create'],
      ['label'=>'List','route'=>'adjustment.raw_product.index'],
    ]],
    ['label'=>'Finish Product','children'=>[
      ['label'=>'Create','route'=>'adjustment.finish_product.create'],
      ['label'=>'List','route'=>'adjustment.finish_product.index'],
    ]],
    ['label'=>'Finish Bag','children'=>[
      ['label'=>'Create','route'=>'adjustment.finish_bag.create'],
      ['label'=>'List','route'=>'adjustment.finish_bag.index'],
    ]],
    ['label'=>'Raw Bag','children'=>[
      ['label'=>'Create','route'=>'adjustment.raw_bag.create'],
      ['label'=>'List','route'=>'adjustment.raw_bag.index'],
    ]],
    ['label'=>'Raw Bag Opening','children'=>[
      ['label'=>'Create Raw Bag','route'=>'adjustment.raw_bag_opening.create'],
      ['label'=>'Bag Opening List','route'=>'adjustment.raw_bag_opening.index'],
    ]],
  ]],
  ['label'=>'Order','icon'=>'fas fa-shopping-cart','children'=>[
    ['label'=>'Create','route'=>'order.create'],
    ['label'=>'List','route'=>'order.index'],
  ]],
  ['label'=>'Order Delivery','icon'=>'fas fa-truck','children'=>[
    ['label'=>'Create','route'=>'order_delivery.create'],
    ['label'=>'List','route'=>'order_delivery.index'],
  ]],
  ['label'=>'Sales','icon'=>'fas fa-balance-scale','children'=>[
    ['label'=>'Create','route'=>'sales.create'],
    ['label'=>'List','route'=>'sales.index'],
  ]],
  ['label'=>'Sales Delivery','icon'=>'fas fa-truck-moving','children'=>[
    ['label'=>'Create','route'=>'sales_delivery.create'],
    ['label'=>'List','route'=>'sales_delivery.index'],
  ]],
  ['label'=>'Issue Raw Material','icon'=>'fas fa-cubes','children'=>[
    ['label'=>'Create','route'=>'issue_rm.create'],
    ['label'=>'List','route'=>'issue_rm.index'],
  ]],
  ['label'=>'Finish Production','icon'=>'fas fa-industry','children'=>[
    ['label'=>'Create','route'=>'production.create'],
    ['label'=>'List','route'=>'production.index'],
  ]],
  ['label'=>'Return','icon'=>'fas fa-undo','children'=>[
    ['label'=>'Raw Purchase Return','children'=>[
      ['label'=>'Create','route'=>'return.raw_purchase.create'],
      ['label'=>'List','route'=>'return.raw_purchase.index'],
    ]],
    ['label'=>'Finish Purchase Return','children'=>[
      ['label'=>'Create','route'=>'return.finish_purchase.create'],
      ['label'=>'List','route'=>'return.finish_purchase.index'],
    ]],
    ['label'=>'Sales Return','children'=>[
      ['label'=>'Create','route'=>'return.sales.create'],
      ['label'=>'List','route'=>'return.sales.index'],
    ]],
    ['label'=>'Order Return','children'=>[
      ['label'=>'Create','route'=>'return.order.create'],
      ['label'=>'List','route'=>'return.order.index'],
    ]],
    ['label'=>'Return Bag','children'=>[
      ['label'=>'Create','route'=>'return.bag.create'],
      ['label'=>'List','route'=>'return.bag.index'],
    ]],
  ]],
  ['label'=>'Labour Cost','icon'=>'fas fa-money-check-alt','children'=>[
    ['label'=>'Create','route'=>'labour.create'],
    ['label'=>'List','route'=>'labour.index'],
  ]],
  ['label'=>'Payment & Due','icon'=>'fas fa-university','children'=>[
    ['label'=>'Customer Due','children'=>[
      ['label'=>'Collect Due','route'=>'payment.collect_due'],
      ['label'=>'Collection List','route'=>'payment.collection_list'],
    ]],
    ['label'=>'Supplier Payment','children'=>[
      ['label'=>'Create','route'=>'payment.supplier.create'],
      ['label'=>'List','route'=>'payment.supplier.index'],
    ]],
  ]],
  ['label'=>'Reports','icon'=>'fas fa-file-alt','children'=>[
    ['label'=>'Raw Material','children'=>[
      ['label'=>'Stock In Hand','route'=>'reports.raw_material.stock_in_hand'],
      ['label'=>'Ledger','route'=>'reports.raw_material.ledger'],
      ['label'=>'Mal Khotiyan','route'=>'reports.raw_material.mal_khotiyan'],
    ]],
    ['label'=>'Finish Product','children'=>[
      ['label'=>'Production Stock','route'=>'reports.finish_product.production_stock'],
      ['label'=>'Production Ledger','route'=>'reports.finish_product.production_ledger'],
      ['label'=>'Purchase Stock','route'=>'reports.finish_product.purchase_stock'],
      ['label'=>'Purchase Ledger','route'=>'reports.finish_product.purchase_ledger'],
    ]],
    ['label'=>'Finish Bag','children'=>[
      ['label'=>'Stock In Hand','route'=>'reports.finish_bag.stock_in_hand'],
      ['label'=>'Ledger','route'=>'reports.finish_bag.ledger'],
    ]],
    ['label'=>'Raw Bag','children'=>[
      ['label'=>'Supplier In Hand','route'=>'reports.raw_bag.supplier_in_hand'],
      ['label'=>'Supplier Bag Ledger','route'=>'reports.raw_bag.supplier_bag_ledger'],
      ['label'=>'Empty bag Stock','route'=>'reports.raw_bag.empty_bag_stock'],
      ['label'=>'Ledger','route'=>'reports.raw_bag.ledger'],
    ]],
    ['label'=>'Sales Report','children'=>[
      ['label'=>'Finish Product','route'=>'reports.sales.finish_product'],
      ['label'=>'Production Product','route'=>'reports.sales.production_product'],
      ['label'=>'Monthly Sale','route'=>'reports.sales.monthly_sale'],
    ]],
    ['label'=>'Order Report','children'=>[
      ['label'=>'Finish Product','route'=>'reports.order.finish_product'],
      ['label'=>'Production Product','route'=>'reports.order.production_product'],
      ['label'=>'Monthly Order','route'=>'reports.order.monthly_order'],
    ]],
    ['label'=>'Purchase Report','children'=>[
      ['label'=>'Raw Product','route'=>'reports.purchase.raw_product'],
      ['label'=>'Finish Product','route'=>'reports.purchase.finish_product'],
      ['label'=>'Finish Bag','route'=>'reports.purchase.finish_bag'],
      ['label'=>'Raw Bag','route'=>'reports.purchase.raw_bag'],
    ]],
    ['label'=>'Damage Report','children'=>[
      ['label'=>'Raw Product','route'=>'reports.damage.raw_product'],
      ['label'=>'Finish Product','route'=>'reports.damage.finish_product'],
      ['label'=>'Raw Bag','route'=>'reports.damage.raw_bag'],
      ['label'=>'Finish Bag','route'=>'reports.damage.finish_bag'],
    ]],
    ['label'=>'Customer Ledger','route'=>'reports.customer_ledger'],
    ['label'=>'Supplier Ledger','route'=>'reports.supplier_ledger'],
    ['label'=>'Supplier Report','route'=>'reports.supplier_report'],
    ['label'=>'Customer Performance','route'=>'reports.customer_performance'],
    ['label'=>'Executive Performance','route'=>'reports.executive_performance'],
    ['label'=>'Production Cost Report','route'=>'reports.production_cost'],
    ['label'=>'Labour Cost Report','route'=>'reports.labour_cost'],
    ['label'=>'Order Return Report','route'=>'reports.order_return'],
    ['label'=>'Sale Return Report','route'=>'reports.sale_return'],
    ['label'=>'Dayar Report','route'=>'reports.dayar'],
    ['label'=>'Mill report','route'=>'reports.mill'],
    ['label'=>'Daily report','route'=>'reports.daily'],
    ['label'=>'Day Book','route'=>'reports.day_book'],
    ['label'=>'Cash Book','route'=>'reports.cash_book'],
  ]],
  ['label'=>'Account','icon'=>'fas fa-landmark','children'=>[
    ['label'=>'Account Mapping','route'=>'account.mapping'],
    ['label'=>'Account Summary','route'=>'account.summary'],
  ]],
  // --- Global Setting ---
  ['label'=>'Global Setting','icon'=>'fas fa-gear','children'=>[
    ['label'=>'Business Settings','route'=>'settings.business'],
    ['label'=>'Invoice Settings','route'=>'settings.invoice'],
    ['label'=>'Printers','route'=>'settings.printers'],
    ['label'=>'Payment Methods','route'=>'settings.payments'],
    ['label'=>'Currencies','route'=>'settings.currencies'],
    ['label' => 'Business Locations', 'route' => 'settings.locations'],
    ['label' => 'Price Groups',       'route' => 'settings.price_groups'],
    ['label' => 'Barcodes',           'route' => 'settings.barcodes'],
  ]],
];
