<?php

namespace App\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class WarehouseType extends Model
{
    use HasFactory;

    protected $table = 'rm_warehouse_types';

    protected $fillable = [
        'name', 'status', 'created_by', 'updated_by',
    ];

    protected $casts = [
        'status' => 'string', // keep '1' / '0'
    ];

    // Relations (optional)
    public function createdBy() { return $this->belongsTo(User::class, 'created_by'); }
    public function updatedBy() { return $this->belongsTo(User::class, 'updated_by'); }

    // Accessors for blade popover
    public function getCreatedByNameAttribute(): string
    {
        return optional($this->createdBy)->name
            ?? ($this->created_by ? (optional(User::find($this->created_by))->name ?? "User #{$this->created_by}") : '—');
    }

    public function getUpdatedByNameAttribute(): string
    {
        return optional($this->updatedBy)->name
            ?? ($this->updated_by ? (optional(User::find($this->updated_by))->name ?? "User #{$this->updated_by}") : '—');
    }

    // Auto-fill created_by / updated_by
    protected static function booted(): void
    {
        static::creating(function (self $m) {
            if (is_null($m->created_by)) $m->created_by = auth()->id();
        });
        static::updating(function (self $m) {
            $m->updated_by = auth()->id() ?? $m->updated_by;
        });
    }
}
