<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Warehouse extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'warehouse_type_id',
        'type',       // INT in DB
        'status',     // tinyint/bool
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'type'   => 'integer',
        'status' => 'integer',
    ];

    /* Relations */
    public function warehouseType() { return $this->belongsTo(WarehouseType::class, 'warehouse_type_id'); }
    public function createdBy()     { return $this->belongsTo(User::class, 'created_by'); }
    public function updatedBy()     { return $this->belongsTo(User::class, 'updated_by'); }

    /* Accessors for UI labels */
    public function getTypeLabelAttribute(): string
    {
        $labels = [1=>'Raw', 2=>'Finish', 3=>'Bag', 4=>'G. Store'];
        return $labels[$this->type] ?? '—';
    }
}
