<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserLoginStatus extends Model
{
    public $timestamps = false;

    protected $fillable = [
        'date',
        'user_id',
        'company_id',
        'session_id',
        'ip_address',
        'user_agent',
        'logged_in_at',
        'logged_out_at',
        'created_at',
        'updated_at',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
