<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class Unit extends Model
{
    // >>> আপনার টেবিল
    protected $table = 'rm_units';

    // timestamps আছে (nullable হলেও Laravel নিজে ভরবে)
    public $timestamps = true;

    // fillable কলাম
    protected $fillable = [
        'name',
        'conversation_size',
        'status',       // '0' or '1' (string)
        'created_by',
        'updated_by',
    ];

    // কাস্টিং
    protected $casts = [
        'conversation_size' => 'decimal:2',
        'status'            => 'string',
    ];

    // created_by / updated_by auto-fill
    protected static function booted(): void
    {
        static::creating(function ($m) {
            $uid = Auth::id();
            // created_by NOT NULL, তাই fallback দিন (প্রয়োজনে 1 বা যে কোন সিস্টেম ইউজার আইডি)
            $m->created_by = $m->created_by ?? ($uid ?? 1);
            // প্রথমবার updated_by-ও সেট করে দিচ্ছি
            $m->updated_by = $m->updated_by ?? ($uid ?? null);
        });

        static::updating(function ($m) {
            if (Auth::check()) {
                $m->updated_by = Auth::id();
            }
        });
    }

    // চাইলে একটি helper attribute (read-only):
    public function getIsActiveAttribute(): bool
    {
        return $this->status === '1';
    }
}
