<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    protected $fillable = ['business_id','package_id','starts_at','ends_at','auto_renew','status'];
    protected $casts = ['starts_at'=>'date','ends_at'=>'date','auto_renew'=>'boolean'];

    public function business() { return $this->belongsTo(Business::class); }
    public function package()  { return $this->belongsTo(Package::class); }

    public function scopeActive($q) {
        return $q->where('status','active')->whereDate('ends_at','>=',now()->toDateString());
    }
}