<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RawProductAdjustment extends Model
{
    use HasFactory;

    /**
     * The table this model maps to.
     */
    protected $table = 'rm_product_adjustments';

    /**
     * Mass-assignable attributes.
     */
    protected $fillable = [
        'warehouse_id',
        'date',
        'adjust_type',   // 'IN' | 'OUT'
        'total_qty',
        'note',
    ];

    /**
     * Attribute casting.
     */
    protected $casts = [
        'date'       => 'date',
        'total_qty'  => 'decimal:2',
    ];

    /**
     * Relations
     */
    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    // If you later add a details table, you can enable this:
    // public function items()
    // {
    //     return $this->hasMany(RawProductAdjustmentItem::class, 'raw_product_adjustment_id');
    // }
}


