<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RawMaterialTransfer extends Model
{
    protected $table = 'rmstock_transfers';
    
    protected $fillable = [
        'from_warehouse_id',
        'to_warehouse_id',
        'transfer_date',
        'transfer_cost',
        'total_kg',
        'total_bag',
        'grand_total_kg',
        'status',
        'created_by'
    ];

    public function fromWarehouse()
    {
        return $this->belongsTo(Warehouse::class, 'from_warehouse_id');
    }

    public function toWarehouse()
    {
        return $this->belongsTo(Warehouse::class, 'to_warehouse_id');
    }

    public function items()
    {
        return $this->hasMany(RawMaterialTransferItem::class, 'rmstock_transfer_id');
    }
}
