<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RawBagOpening extends Model
{
    use HasFactory;

    /** Table where data will be stored */
    protected $table = 'raw_bag_openings';

    /** Mass-assignable columns */
    protected $fillable = [
        'company_id',
        'warehouse_id',
        'opening_qty',
        'note',
        'date',
    ];

    /** Useful casting */
    protected $casts = [
        'date'         => 'date',
        'opening_qty'  => 'decimal:2',
    ];

    /* ----------------- Relationships ----------------- */

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    /* ----------------- Optional scopes ----------------- */

    public function scopeCompany($query, $companyId = null)
    {
        return $companyId ? $query->where('company_id', $companyId) : $query;
    }

    public function scopeWarehouse($query, $warehouseId = null)
    {
        return $warehouseId ? $query->where('warehouse_id', $warehouseId) : $query;
    }
}
