<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RawBagAdjustment extends Model
{
    protected $table = 'raw_bag_adjustments';

    protected $fillable = [
        'company_id',
        'warehouse_id',
        'date',
        'total_qty',
        'note',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }
}

