<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OrderDelivery extends Model
{
    use HasFactory;

    /** Explicit table name */
    protected $table = 'rm_order_deliveries';

    /**
     * Keep it simple: allow mass assignment for all columns
     * (use $fillable if you want to whitelist specific fields)
     */
    protected $guarded = [];

    /** Useful casts */
    protected $casts = [
        'delivery_date' => 'date',
        'total_qty'     => 'decimal:3',
        'total_amount'  => 'decimal:2',
    ];

    /* ---------------- Relations (optional but handy) ---------------- */

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }

    // If your orders are in rm_orders and you have Order model pointing there
    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }
}

