<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Order extends Model
{
    protected $table = 'rm_orders';

    protected $fillable = [
        'company_id', 'customer_id', 'employee_id',
        'order_date', 'delivery_date',
        'customer_due', 'total_qty', 'grand_total',
        'created_by',
    ];

    protected $casts = [
        'order_date'    => 'date',
        'delivery_date' => 'date',
        'customer_due'  => 'decimal:2',
        'total_qty'     => 'decimal:3',
        'grand_total'   => 'decimal:2',
    ];

    public function items(): HasMany
    {
        return $this->hasMany(OrderItem::class, 'order_id');
    }

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }

    public function employee(): BelongsTo
    {
        return $this->belongsTo(Employee::class);
    }
}
